package ru.yandex.direct.core.entity.bids.interpolator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

import ru.yandex.direct.utils.math.Point;

import static com.google.common.base.Preconditions.checkArgument;

public class InterpolatorUtils {
    private InterpolatorUtils() {
    }

    /**
     * Округляет double до places знаков после запятой
     *
     * @param value  -- округляемое значение
     * @param places -- число знаков после запятой
     */
    public static double round(double value, int places) {
        checkArgument(places >= 0, "The number of decimal places can not be negative");

        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    /**
     * Проверяет, что переданные точки создают неубывающую последовательность
     */
    public static boolean checkPointsAreNonDecreasing(List<Point> points) {
        for (int i = 1; i < points.size(); i++) {
            if (points.get(i).getY() < points.get(i - 1).getY()) {
                return false;
            }
        }
        return true;
    }

    /**
     * Проверяет, что переданные точки отсортированы по возрастанию
     */
    public static boolean checkPointsAreSorted(List<Point> points) {
        for (int i = 1; i < points.size(); i++) {
            if (points.get(i).compareTo(points.get(i - 1)) < 0) {
                return false;
            }
        }
        return true;
    }
}
