package ru.yandex.direct.core.entity.bids.repository;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.bids.service.BidBaseOpt;
import ru.yandex.direct.dbschema.ppc.enums.BidsBaseStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.BidsStatusbssynced;

import static java.lang.Boolean.TRUE;
import static org.apache.commons.lang3.StringUtils.isBlank;

public class BidMappings {

    private BidMappings() {
    }

    public static BidsBaseStatusbssynced statusBsSyncedToDbFormat(StatusBsSynced statusBsSynced) {
        return statusBsSynced != null ? BidsBaseStatusbssynced.valueOf(statusBsSynced.toDbFormat()) : null;
    }

    public static StatusBsSynced statusBsSyncedFromDbFormat(BidsBaseStatusbssynced bidsStatusBsSynced) {
        return bidsStatusBsSynced != null ? StatusBsSynced.valueOfDbFormat(bidsStatusBsSynced.toString()) : null;
    }

    public static BidsStatusbssynced statusBsSyncedToDbFormatForBid(StatusBsSynced statusBsSynced) {
        return statusBsSynced != null ? BidsStatusbssynced.valueOf(statusBsSynced.toDbFormat()) : null;
    }

    public static StatusBsSynced statusBsSyncedFromDbFormatForBid(BidsStatusbssynced bidsStatusBsSynced) {
        return bidsStatusBsSynced != null ? StatusBsSynced.valueOfDbFormat(bidsStatusBsSynced.toString()) : null;
    }

    public static Boolean isDeletedFromDbOpts(String opts) {
        return !isBlank(opts) && opts.contains(BidBaseOpt.DELETED.getTypedValue());
    }

    public static Boolean isSuspendedFromDbOpts(String opts) {
        return !isBlank(opts) && opts.contains(BidBaseOpt.SUSPENDED.getTypedValue());
    }


    public static String bidPropsToDbOpts(Boolean isSuspended, Boolean isDeleted) {
        return StreamEx.of(
                TRUE.equals(isSuspended) ? BidBaseOpt.SUSPENDED.getTypedValue() : null,
                TRUE.equals(isDeleted) ? BidBaseOpt.DELETED.getTypedValue() : null)
                .nonNull()
                .joining(",");
    }
}
