package ru.yandex.direct.core.entity.bids.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.auction.container.bs.KeywordTrafaretData;
import ru.yandex.direct.core.entity.auction.container.bs.TrafaretBidItem;
import ru.yandex.direct.core.entity.bids.container.CompleteBidData;
import ru.yandex.direct.core.entity.bids.model.Bid;
import ru.yandex.direct.currency.Money;
import ru.yandex.direct.dbutil.model.ClientId;

/**
 * Сервис предназначен для получения гарантированной позиции для ставок на ключевые фразы.
 * Фасад для KeywordBidDynamicDataService
 */
@Service
@ParametersAreNonnullByDefault
public class BidBsStatisticFacade {
    private static final Logger logger = LoggerFactory.getLogger(BidBsStatisticFacade.class);
    private static final Long GUARANTEE1_X = 85000L;//Прогноз первого места в Гарантии. Позиция
    private final KeywordBidDynamicDataService keywordBidDynamicDataService;

    public BidBsStatisticFacade(KeywordBidDynamicDataService keywordBidDynamicDataService) {
        this.keywordBidDynamicDataService = keywordBidDynamicDataService;
    }

    public Map<Long, Money> bidBsStatisticFirstPosition(ClientId clientId, List<Bid> bids) {
        try {
            Collection<CompleteBidData<KeywordTrafaretData>> bidBsStatistic = keywordBidDynamicDataService
                    .getCompleteBidDataTrafaretFormat(clientId, bids, false, true /*withBsAuction*/,
                            false /*safePokazometer*/);
            Map<Long, Money> res = new HashMap<>(bidBsStatistic.size());
            for (CompleteBidData<KeywordTrafaretData> completeBidData : bidBsStatistic) {
                if (completeBidData.getDynamicData() != null
                        && completeBidData.getDynamicData().getBsAuctionData() != null
                        && completeBidData.getDynamicData().getBsAuctionData().getBidItems() != null) {
                    for (TrafaretBidItem item : completeBidData.getDynamicData().getBsAuctionData().getBidItems()) {
                        if (item.getPositionCtrCorrection() == GUARANTEE1_X) {
                            res.put(completeBidData.getBidId(),
                                    item.getBid());
                        }
                    }
                }
            }
            return res;
        } catch (Exception e) {
            logger.warn("BsAuction not available: " + e.getMessage(), e);
            return Collections.emptyMap();
        }
    }
}
