package ru.yandex.direct.core.entity.bids.service;

import java.util.List;

import ru.yandex.direct.core.entity.bids.model.Bid;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.model.AppliedChanges;

public interface BidSetAutoPriceApplier {

    /**
     * Вычисляет новые значения ставок для автотаргетинга и применяет их к существующим {@link Bid}
     *
     * @param keywordChanges на ставку автотаргетинга влияют новые ставки фраз, изменения которых приезжают тут
     * @return список {@link AppliedChanges} &ndash; изменений, применённых к ставкам
     */
    List<AppliedChanges<Bid>> calcNewPriceForRelevanceMatchAndApply(List<AppliedChanges<Keyword>> keywordChanges);

    /**
     * Вычисляет новые значения ставок для ключевых фраз и применяет их к существующим {@link Bid}
     *
     * @return список {@link AppliedChanges} &ndash; изменений, применённых к ставкам
     */
    List<AppliedChanges<Keyword>> calcNewPriceForKeywordAndApply();
}
