package ru.yandex.direct.core.entity.bids.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.auction.container.bs.KeywordBidBsAuctionData;
import ru.yandex.direct.core.entity.auction.container.bs.KeywordTrafaretData;
import ru.yandex.direct.core.entity.auction.utils.BsAuctionConverter;
import ru.yandex.direct.core.entity.bids.container.CompleteBidData;
import ru.yandex.direct.core.entity.bids.container.KeywordBidDynamicData;
import ru.yandex.direct.core.entity.bids.container.SetAutoBidItem;
import ru.yandex.direct.core.entity.bids.utils.autoprice.PlaceSearch;
import ru.yandex.direct.core.entity.bids.utils.autoprice.PriceWizard;
import ru.yandex.direct.core.entity.bids.utils.autoprice.PriceWizardHelper;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.keyword.model.Place;
import ru.yandex.direct.model.ModelChanges;

class BidSetAutoPriceByTrafficVolumeApplier extends AbstractBidSetAutoPriceApplier<KeywordTrafaretData> {
    private static final Logger logger = LoggerFactory.getLogger(BidSetAutoPriceByTrafficVolumeApplier.class);

    BidSetAutoPriceByTrafficVolumeApplier(
            List<SetAutoBidItem> setAutoBidItems,
            Collection<CompleteBidData<KeywordTrafaretData>> completeBidData,
            Collection<Keyword> keywords) {
        super(setAutoBidItems, completeBidData, keywords);
    }

    @Override
    protected void calcNewSearchPriceForKeyword(ModelChanges<? extends BidBase> keywordChanges,
                                                PriceWizardHelper wizardHelper) {
        Long bidId = keywordChanges.getId();
        CompleteBidData<KeywordTrafaretData> completeBidDataItem = completeBidDataById.get(bidId);
        KeywordBidDynamicData<KeywordTrafaretData> bidDynamicData = completeBidDataItem.getDynamicData();
        PriceWizard<KeywordTrafaretData> roundedSearchPriceWizard =
                wizardHelper.getRoundedSearchPriceByTrafficVolumeWizard();
        KeywordTrafaretData bsTrafaretAuctionData = bidDynamicData.getBsAuctionData();
        if (bsTrafaretAuctionData == null) {
            logger.debug("No bs auction data for keyword (id={}). Keyword search bid will not be updated", bidId);
            return;
        }
        BigDecimal newSearchPrice = roundedSearchPriceWizard.calcPrice(bsTrafaretAuctionData);
        keywordChanges.processNotNull(newSearchPrice, Keyword.PRICE);
        if (keywordChanges.isPropChanged(Keyword.PRICE)) {
            // Если изменилась ставка у ключевой фразы, найдём позицию, которая соответствует новой ставке
            KeywordBidBsAuctionData bsAuctionData = BsAuctionConverter
                    .convertToPositionsAuctionData(bsTrafaretAuctionData,
                            completeBidDataItem.getCampaign().getCurrency().getCurrency());
            Place newPlace = new PlaceSearch(bsAuctionData).findPlaceByPrice(newSearchPrice);
            keywordChanges = keywordChanges.castModelUp(Keyword.class).processNotNull(newPlace, Keyword.PLACE);
        }
    }
}
