package ru.yandex.direct.core.entity.bids.service;


import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.bids.container.BiddingShowCondition;
import ru.yandex.direct.core.entity.bids.container.SetBidItem;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.bids.validation.SetBidConstraints.bidsFieldValidator;

@Service
@ParametersAreNonnullByDefault
public class BidsSetValidationService {

    private final CommonSetBidsValidationService commonSetBidsValidationService;

    @Autowired
    public BidsSetValidationService(CommonSetBidsValidationService commonSetBidsValidationService) {
        this.commonSetBidsValidationService = commonSetBidsValidationService;
    }

    public ValidationResult<List<SetBidItem>, Defect> preValidate(List<SetBidItem> setBidItemList) {
        return ListValidationBuilder.<SetBidItem, Defect>of(setBidItemList)
                .checkBy(commonSetBidsValidationService::preValidate)
                .checkEachBy(bidsFieldValidator())
                .getResult();
    }

    public <T extends BiddingShowCondition> ValidationResult<List<SetBidItem>, Defect> validate(
            BidValidationContainer<T> bidValidationContainer,
            List<SetBidItem> setBidItemList) {
        return ListValidationBuilder.<SetBidItem, Defect>of(setBidItemList)
                .checkBy(commonBidValidator(bidValidationContainer))
                .getResult();
    }

    private <T extends BiddingShowCondition> Validator<List<SetBidItem>, Defect> commonBidValidator(
            BidValidationContainer<T> bidValidationContainer) {
        return setBidItems -> commonSetBidsValidationService.validate(bidValidationContainer, setBidItems, true);
    }
}
