package ru.yandex.direct.core.entity.bids.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.bids.container.SetAutoBidItem;
import ru.yandex.direct.core.entity.bids.model.Bid;
import ru.yandex.direct.core.entity.bids.validation.SetAutoBidValidator;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.bids.validation.SetBidConstraints.selectionFieldCountValidator;
import static ru.yandex.direct.core.entity.bids.validation.SetBidConstraints.selectorsAreOfSameType;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Service
@ParametersAreNonnullByDefault
public class SetAutoBidsValidationService {
    @Autowired
    public SetAutoBidsValidationService() {
    }

    /**
     * Проверки уровня запроса: количество элементов, соответствие типов и т.п.
     */
    public ValidationResult<List<SetAutoBidItem>, Defect> preValidate(List<SetAutoBidItem> setBidItemList) {
        ListValidationBuilder<SetAutoBidItem, Defect> vb =
                ListValidationBuilder.of(setBidItemList, Defect.class)
                        .checkBy(this::validateOperation);
        vb.checkEachBy(selectionFieldCountValidator(), When.isValid());
        return vb.getResult();
    }

    private ValidationResult<List<SetAutoBidItem>, Defect> validateOperation(
            List<SetAutoBidItem> setBidItems) {
        return ListValidationBuilder.<SetAutoBidItem, Defect>of(setBidItems)
                .check(notNull())
                .check(eachNotNull(), When.isValid())
                .check(selectorsAreOfSameType(), When.isValid())
                .getResult();
    }

    /**
     * Проверки существования ставок, видимости кампаний, отдельных элементов {@link SetAutoBidItem}
     *
     * @see SetAutoBidValidator
     */
    public ValidationResult<List<SetAutoBidItem>, Defect> validate(
            BidValidationContainer<Bid> bidValidationContainer,
            List<SetAutoBidItem> setBidItemList, boolean isKeywordBidsService) {


        return ListValidationBuilder.<SetAutoBidItem, Defect>of(setBidItemList)
                .checkBy(this::validateOperation)
                .checkBy(new SetAutoBidValidator(bidValidationContainer, isKeywordBidsService), When.isValid())
                .getResult();
    }

}
