package ru.yandex.direct.core.entity.bids.utils;

import java.util.Map;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.bids.container.KeywordBidPokazometerData;
import ru.yandex.direct.core.entity.bids.service.PokazometerService;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.currency.Money;
import ru.yandex.direct.pokazometer.PhraseResponse;

/**
 * Набор утилитных методов для {@link PokazometerService}
 */
public class PokazometerUtils {

    private PokazometerUtils() {
    }

    /**
     * Преобразует {@link PhraseResponse} в {@link KeywordBidPokazometerData} с данными о покрытии
     * для ключевой фразы {@code keyword}.
     */
    public static KeywordBidPokazometerData convertPhraseResponse(Keyword keyword, PhraseResponse phraseResponse) {
        Map<PhraseResponse.Coverage, Money> coverageMoneyMap = EntryStream.of(phraseResponse.getPriceByCoverage())
                .mapValues(amount -> Money.valueOfMicros(amount, CurrencyCode.YND_FIXED))
                .toMap();

        Map<Money, Integer> allCoveragePrice = EntryStream.of(phraseResponse.getClicksByCost())
                .mapKeys(price -> Money.valueOfMicros(price, CurrencyCode.YND_FIXED))
                .toMap();

        return new KeywordBidPokazometerData(keyword.getId(), coverageMoneyMap, allCoveragePrice);
    }

    public static KeywordBidPokazometerData convertPhraseResponse(PhraseResponse phraseResponse) {
        Map<PhraseResponse.Coverage, Money> coverageMoneyMap = EntryStream.of(phraseResponse.getPriceByCoverage())
                .mapValues(amount -> Money.valueOfMicros(amount, CurrencyCode.YND_FIXED))
                .toMap();

        Map<Money, Integer> allCoveragePrice = EntryStream.of(phraseResponse.getClicksByCost())
                .mapKeys(price -> Money.valueOfMicros(price, CurrencyCode.YND_FIXED))
                .toMap();

        return new KeywordBidPokazometerData(phraseResponse.getKeywordId(), coverageMoneyMap, allCoveragePrice);
    }
}
