package ru.yandex.direct.core.entity.bids.utils;

import java.math.BigDecimal;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.Money;

@ParametersAreNonnullByDefault
public class PriceUtils {
    /**
     * Применяет к поисковой ставке коэффициент {@code ContextPriceCoef}.
     * Если коэффициент равен нулю или 100, возвращается неизмененная ставка.
     * <p>
     * Скорректированная ставка округляется вверх до шага торгов.
     *
     * @param currency валюта клиента
     */
    public static BigDecimal applyContextPriceCoef(BigDecimal searchPrice, int contextPriceCoef, Currency currency) {
        if (contextPriceCoef == 0 || contextPriceCoef == 100) {
            return searchPrice;
        }
        return Money.valueOf(searchPrice, currency.getCode())
                .multiply(contextPriceCoef / 100.0)
                .adjustToCurrencyRange()
                .roundToAuctionStepUp()
                .bigDecimalValue();
    }
}
