package ru.yandex.direct.core.entity.bids.utils.autoprice;

import java.util.List;
import java.util.function.Function;

import ru.yandex.direct.core.entity.auction.container.bs.Block;
import ru.yandex.direct.core.entity.auction.container.bs.KeywordBidBsAuctionData;
import ru.yandex.direct.core.entity.auction.container.bs.Position;
import ru.yandex.direct.core.entity.keyword.model.Place;

import static java.util.Arrays.asList;

/**
 * Описывает связь {@link Place} с конкретными описаниями позиций на Поиске {@link Position}
 */
class PlaceItem {
    private final Function<KeywordBidBsAuctionData, Block> blockGetter;
    private final int positionInBlock;
    private final List<Place> relatedPlaces;

    private PlaceItem(Function<KeywordBidBsAuctionData, Block> blockGetter, int positionInBlock,
                      Place... relatedPlaces) {
        this.blockGetter = blockGetter;
        this.positionInBlock = positionInBlock;
        this.relatedPlaces = asList(relatedPlaces);
    }

    static PlaceItem placeItem(Function<KeywordBidBsAuctionData, Block> blockGetter, int positionInBlock,
                               Place... relatedPlaces) {
        return new PlaceItem(blockGetter, positionInBlock, relatedPlaces);
    }

    /**
     * Извлекает из описания блоков Спецразмещения и Гарантии описание соответствующей позиции {@link Position}
     */
    Position getPosition(KeywordBidBsAuctionData auctionData) {
        return blockGetter.apply(auctionData).get(positionInBlock);
    }

    List<Place> getRelatedPlaces() {
        return relatedPlaces;
    }

    Place getFirstRelatedPlace() {
        return relatedPlaces.get(0);
    }
}
