package ru.yandex.direct.core.entity.bids.utils.autoprice;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.auction.container.bs.KeywordBidBsAuctionData;
import ru.yandex.direct.core.entity.keyword.model.Place;

import static java.util.Arrays.asList;

/**
 * Опредеяет позицию на Поиске по величине ставки и данным о ценах размещений
 */
public class PlaceSearch {

    private static final List<PlaceItem> PLACES = asList(
            PlaceItem.placeItem(KeywordBidBsAuctionData::getPremium, 0,
                    Place.PREMIUM1),
            PlaceItem.placeItem(KeywordBidBsAuctionData::getPremium, 1,
                    Place.PREMIUM2),
            PlaceItem.placeItem(KeywordBidBsAuctionData::getPremium, 2,
                    Place.PREMIUM3),
            PlaceItem.placeItem(KeywordBidBsAuctionData::getPremium, -1,
                    Place.PREMIUM4),
            PlaceItem.placeItem(KeywordBidBsAuctionData::getGuarantee, 0,
                    Place.GUARANTEE1),
            PlaceItem.placeItem(KeywordBidBsAuctionData::getGuarantee, 1,
                    Place.GUARANTEE2),
            PlaceItem.placeItem(KeywordBidBsAuctionData::getGuarantee, 2,
                    Place.GUARANTEE3),
            PlaceItem.placeItem(KeywordBidBsAuctionData::getGuarantee, -1,
                    Place.GUARANTEE4));

    private final KeywordBidBsAuctionData bsAuctionData;

    public PlaceSearch(KeywordBidBsAuctionData bsAuctionData) {
        this.bsAuctionData = bsAuctionData;
    }

    /**
     * @return {@link Place} &ndash; соответствующая указанной ставке {@code price}.
     */
    public Place findPlaceByPrice(BigDecimal price) {
        Predicate<PlaceItem> placeAcceptableForPrice = place ->
                price.compareTo(place.getPosition(bsAuctionData).getBidPrice().bigDecimalValue()) >= 0;
        return StreamEx.of(PLACES)
                .findFirst(placeAcceptableForPrice)
                .map(PlaceItem::getFirstRelatedPlace)
                .orElse(Place.ROTATION);
    }
}
