package ru.yandex.direct.core.entity.bids.utils.autoprice;

import java.math.BigDecimal;
import java.util.List;

import ru.yandex.direct.core.entity.auction.container.bs.KeywordTrafaretData;
import ru.yandex.direct.utils.math.Point;

import static ru.yandex.direct.core.entity.bids.utils.autoprice.SearchPriceByTrafficVolumeHelper.calcTargetBid;
import static ru.yandex.direct.core.entity.bids.utils.autoprice.SearchPriceByTrafficVolumeHelper.getPoints;

/**
 * Мастер вычисления ставок на поиске по данным Трафаретных торгов, проставляющий максимально доступный объем траффика
 */
public class SearchPriceByMaxTrafficVolumeWizard implements PriceWizard<KeywordTrafaretData> {

    private final Integer increasePercent;

    private SearchPriceByMaxTrafficVolumeWizard(Integer increasePercent) {
        this.increasePercent = increasePercent;
    }

    static SearchPriceByMaxTrafficVolumeWizard createWizard(Integer increasePercent) {
        return new SearchPriceByMaxTrafficVolumeWizard(increasePercent);
    }

    @Override
    public BigDecimal calcPrice(KeywordTrafaretData trafaretData) {
        List<Point> points = getPoints(trafaretData);
        //Так как список points сортированный для получения максимального объема трафика берем последнюю запись.
        if (points == null || points.isEmpty()) {
            throw new IllegalStateException("Cannot get value from empty collection");
        }
        Double trafficVolume = points.get(points.size() - 1).getX();
        return calcTargetBid(trafficVolume, increasePercent, points);
    }
}
