package ru.yandex.direct.core.entity.bids.utils.autoprice;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.auction.container.bs.KeywordTrafaretData;
import ru.yandex.direct.utils.math.MathUtils;
import ru.yandex.direct.utils.math.Point;

@ParametersAreNonnullByDefault
public class SearchPriceByTrafficVolumeHelper {

    static BigDecimal calcTargetBid(Double trafficVolume, @Nullable Integer increasePercent,
                                    List<Point> points) {
        Point point = MathUtils.interpolateLinear(trafficVolume, points);
        BigDecimal targetBid = BigDecimal.valueOf(point.getY());

        BigDecimal multiplicand;
        if (increasePercent != null) {
            multiplicand = BigDecimal.valueOf(increasePercent, 2);
        } else {
            multiplicand = BigDecimal.ZERO;
        }

        return targetBid.add(targetBid.multiply(multiplicand));
    }

    static List<Point> getPoints(KeywordTrafaretData trafaretData) {
        return StreamEx.of(trafaretData.getBidItems().stream())
                .map(i -> Point.fromDoubles(
                        i.getPositionCtrCorrection() / 10_000.,
                        i.getBid().bigDecimalValue().doubleValue()
                ))
                .sorted()
                .collapse((p1, p2) -> p1.getX() == p2.getX(), (p1, p2) -> p2)
                .collect(Collectors.toList());
    }
}
