package ru.yandex.direct.core.entity.bids.utils.autoprice;

import java.math.BigDecimal;
import java.util.List;

import ru.yandex.direct.core.entity.auction.container.bs.KeywordTrafaretData;
import ru.yandex.direct.utils.math.Point;

import static ru.yandex.direct.core.entity.bids.utils.autoprice.SearchPriceByTrafficVolumeHelper.calcTargetBid;
import static ru.yandex.direct.core.entity.bids.utils.autoprice.SearchPriceByTrafficVolumeHelper.getPoints;

/**
 * Мастер вычисления ставок на поиске по данным Трафаретных торгов
 */
public class SearchPriceByTrafficVolumeWizard implements PriceWizard<KeywordTrafaretData> {

    private final Integer increasePercent;
    private final Double trafficVolume;

    private SearchPriceByTrafficVolumeWizard(Integer increasePercent, Double trafficVolume) {
        this.increasePercent = increasePercent;
        this.trafficVolume = trafficVolume;
    }

    static SearchPriceByTrafficVolumeWizard createWizard(Integer increasePercent, Double trafficVolume) {
        return new SearchPriceByTrafficVolumeWizard(increasePercent, trafficVolume);
    }

    @Override
    public BigDecimal calcPrice(KeywordTrafaretData trafaretData) {
        List<Point> points = getPoints(trafaretData);
        return calcTargetBid(trafficVolume, increasePercent, points);
    }
}
