package ru.yandex.direct.core.entity.bids.validation;

import java.util.Collection;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.primitives.Ints.asList;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

public class AutobudgetValidator2 implements Validator<Integer, Defect> {

    private static final Collection<Integer> VALID_PRIORITY_VALUES = asList(1, 3, 5);

    @Override
    public ValidationResult<Integer, Defect> apply(Integer integer) {
        ItemValidationBuilder<Integer, Defect> ivb = ItemValidationBuilder.of(integer);
        ivb.check(fromPredicate(VALID_PRIORITY_VALUES::contains, invalidValue()));
        return ivb.getResult();
    }
}
