package ru.yandex.direct.core.entity.bids.validation;

import java.math.BigDecimal;

import ru.yandex.direct.core.validation.defects.MoneyDefects;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.Money;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

/**
 * @deprecated use {@link PriceValidator} instead.
 */
@Deprecated
public class BidPriceValidator2 implements Validator<BigDecimal, Defect> {

    private final Currency workCurrency;

    public BidPriceValidator2(Currency workCurrency) {
        this.workCurrency = workCurrency;
    }

    @Override
    public ValidationResult<BigDecimal, Defect> apply(BigDecimal bidPrice) {
        ItemValidationBuilder<BigDecimal, Defect> ivb = ItemValidationBuilder.of(bidPrice);
        if (bidPrice == null) {
            return ivb.getResult();
        }
        ivb
                .check(fromPredicate(price -> price.compareTo(workCurrency.getMinPrice()) >= 0,
                        MoneyDefects.invalidValueNotLessThan(
                                Money.valueOf(workCurrency.getMinPrice(), workCurrency.getCode()))))
                .check(fromPredicate(price -> price.compareTo(workCurrency.getMaxPrice()) <= 0,
                        MoneyDefects.invalidValueNotGreaterThan(
                                Money.valueOf(workCurrency.getMaxPrice(), workCurrency.getCode()))));
        return ivb.getResult();
    }
}
