package ru.yandex.direct.core.entity.bids.validation;

import java.util.List;
import java.util.Objects;

import ru.yandex.direct.core.validation.defects.params.CurrencyAmountDefectParams;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

public class BidsDefects {

    public static Defect<Void> mixedTypes() {
        return new Defect<>(Ids.MIXED_TYPES);
    }


    public static Defect<BidsParams> badStatusCampaignArchivedOnUpdateBids(
            ModelProperty field,
            Long campaignId) {
        return new Defect<>(Bids.BAD_STATUS_CAMPAIGN_ARCHIVED_ON_UPDATE_BIDS,
                new BidsParams()
                        .withField(field)
                        .withId(campaignId));
    }

    public static Defect<List<ModelProperty<?, ?>>> requiredAtLeastOneOfFields(
            List<ModelProperty<?, ?>> fields) {
        return new Defect<>(ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS, fields);
    }

    public static Defect<List<ModelProperty<?, ?>>> requiredAtLeastOneOfFieldsForManualStrategy(
            List<ModelProperty<?, ?>> fields) {
        return new Defect<>(ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_MANUAL_STRATEGY, fields);
    }

    public static Defect<List<ModelProperty<?, ?>>> requiredAtLeastOneOfFieldsForAutobudgetStrategy(
            List<ModelProperty<?, ?>> fields) {
        return new Defect<>(ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_AUTOBUDGET_STRATEGY, fields);
    }

    public static Defect<List<ModelProperty<?, ?>>> possibleOnlyOneField(List<ModelProperty<?, ?>> fields) {
        return new Defect<>(ModelDefects.POSSIBLE_ONLY_ONE_FIELD, fields);
    }

    public static Defect<List<ModelProperty<?, ?>>> oneOfFieldsShouldBeSpecified(
            List<ModelProperty<?, ?>> fields) {
        return new Defect<>(ModelDefects.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED, fields);
    }

    public static Defect<BidsParams> notFoundShowConditionByParameters(BidsParams params) {
        return new Defect<>(Bids.NOT_FOUND_SHOW_CONDITION_BY_PARAMETERS,
                params);
    }

    public static Defect<BidsParams> fieldDoesNotMatchStrategy(BidsParams params) {
        return new Defect<>(Bids.FIELD_DOES_NOT_MATCH_STRATEGY,
                params);
    }

    public static Defect<BidsParams> fieldRequiredForSearchStrategy(BidsParams params) {
        return new Defect<>(Bids.FIELD_REQUIRED_FOR_SEARCH_STRATEGY, params);
    }

    public static Defect<BidsParams> fieldRequiredForContextStrategy(BidsParams params) {
        return new Defect<>(Bids.FIELD_REQUIRED_FOR_CONTEXT_STRATEGY, params);
    }

    public static Defect<BidsParams2Fields> dependentFieldMissing(BidsParams2Fields params) {
        return new Defect<>(BidsDefects2Fields.DEPENDENT_FIELD_MISSING, params);
    }

    public static Defect<BidsParams> relevanceMatchCantBeUsedInSetAuto(BidsParams params) {
        return new Defect<>(Bids.RELEVANCE_MATCH_CANT_BE_USED_IN_SET_AUTO, params);
    }

    static Defect<Void> bidChangeNotAllowedForAutobudgetStrategy() {
        return new Defect<>(Ids.BID_NOT_ALLOWED_FOR_AUTOBUDGET_STRATEGY);
    }

    public static Defect<Void> bidChangeNotAllowedForBsRarelyLoadedAdGroup() {
        return new Defect<>(Ids.BID_NOT_ALLOWED_FOR_BS_RARELY_LOADED_ADGROUP);
    }

    public enum Ids implements DefectId<Void> {
        MIXED_TYPES,

        STRATEGY_IS_NOT_SET,

        SEARCH_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY,
        CONTEXT_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY,

        PRIORITY_IS_NOT_SET_FOR_AUTO_STRATEGY,
        PRIORITY_WONT_BE_ACCEPTED_IN_CASE_OF_NOT_AUTO_BUDGET_STRATEGY,
        PRIORITY_HAS_WRONG_VALUE,

        BID_NOT_ALLOWED_FOR_AUTOBUDGET_STRATEGY,
        BID_NOT_ALLOWED_FOR_BS_RARELY_LOADED_ADGROUP,

        BID_FOR_SEARCH_NOT_ALLOWED_SEARCH_IS_SWITCHED_OFF,
        BID_FOR_CONTEXT_NOT_ALLOWED_NET_IS_SWITCHED_OFF,
        BID_FOR_CONTEXT_NOT_ALLOWED_NOT_DIFFERENT_PLACES,

        BID_FOR_SEARCH_WONT_BE_ACCEPTED_SEARCH_IS_SWITCHED_OFF,
        BID_FOR_SEARCH_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY,
        BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NET_IS_SWITCHED_OFF,
        BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NOT_DIFFERENT_PLACES,
        BID_FOR_CONTEXT_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY,
    }

    public enum Bids implements DefectId<BidsParams> {
        BAD_STATUS_CAMPAIGN_ARCHIVED_ON_UPDATE_BIDS,
        NOT_FOUND_SHOW_CONDITION_BY_PARAMETERS,
        FIELD_DOES_NOT_MATCH_STRATEGY,
        FIELD_REQUIRED_FOR_SEARCH_STRATEGY,
        FIELD_REQUIRED_FOR_CONTEXT_STRATEGY,
        RELEVANCE_MATCH_CANT_BE_USED_IN_SET_AUTO,
    }

    public enum BidsDefects2Fields implements DefectId<BidsParams2Fields> {
        DEPENDENT_FIELD_MISSING
    }

    public enum CurrencyAmountDefects implements DefectId<CurrencyAmountDefectParams> {
        SEARCH_PRICE_IS_NOT_GREATER_THAN_MIN,
        SEARCH_PRICE_IS_NOT_SMALLER_THAN_MAX,
        CPM_PRICE_IS_NOT_GREATER_THAN_MIN,
        CPM_PRICE_IS_NOT_SMALLER_THAN_MAX,
    }

    public enum ModelDefects implements DefectId<List<ModelProperty<?, ?>>> {
        REQUIRED_AT_LEAST_ONE_OF_FIELDS,
        REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_MANUAL_STRATEGY,
        REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_AUTOBUDGET_STRATEGY,
        POSSIBLE_ONLY_ONE_FIELD,
        ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
    }

    public static class BidsParams {
        private Long id;
        private ModelProperty field;

        public Long getId() {
            return id;
        }

        public BidsParams withId(Long id) {
            this.id = id;
            return this;
        }

        public ModelProperty getField() {
            return field;
        }

        public BidsParams withField(ModelProperty field) {
            this.field = field;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }

            BidsParams that = (BidsParams) o;

            return Objects.equals(id, that.id) &&
                    Objects.equals(field, that.field);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, field);
        }
    }

    public static class BidsParams2Fields extends BidsParams {
        private ModelProperty field2;

        public ModelProperty getField2() {
            return field2;
        }

        public BidsParams2Fields withField2(ModelProperty field2) {
            this.field2 = field2;
            return this;
        }

        @Override
        public BidsParams2Fields withId(Long id) {
            super.withId(id);
            return this;
        }

        @Override
        public BidsParams2Fields withField(ModelProperty field) {
            super.withField(field);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }

            BidsParams2Fields that = (BidsParams2Fields) o;

            return Objects.equals(field2, that.field2);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), field2);
        }
    }
}
