package ru.yandex.direct.core.entity.brandlift.service.targetestimation;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TargetEstimation {

    private Long campaignId;

    private Long targetForecast;

    private Integer trafficLightColour;

    public TargetEstimation(Long campaignId, Long targetForecast, Integer trafficLightColour) {
        this.campaignId = campaignId;
        this.targetForecast = targetForecast;
        this.trafficLightColour = trafficLightColour;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public TargetEstimation withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getTargetForecast() {
        return targetForecast;
    }

    public TargetEstimation withTargetForecast(Long targetForecast) {
        this.targetForecast = targetForecast;
        return this;
    }

    public Integer getTrafficLightColour() {
        return trafficLightColour;
    }

    public TargetEstimation setTrafficLightColour(Integer trafficLightColour) {
        this.trafficLightColour = trafficLightColour;
        return this;
    }
}
