package ru.yandex.direct.core.entity.bs.common.repository;

import java.util.Collection;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;

@Repository
@ParametersAreNonnullByDefault
public class BsCommonRepository {

    private final DslContextProvider dslContextProvider;

    public BsCommonRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Возвращает набор соответствий campaignId -> OrderId, сохранённых в кампаниях
     *
     * @return отображение campaignId в OrderID
     */
    @Nonnull
    public Map<Long, Long> getOrderIdForCampaigns(DSLContext context, Collection<Long> campaignIds) {
        return context
                .select(CAMPAIGNS.CID, CAMPAIGNS.ORDER_ID)
                .from(CAMPAIGNS)
                .where(CAMPAIGNS.CID.in(campaignIds))
                .fetchMap(CAMPAIGNS.CID, CAMPAIGNS.ORDER_ID);
    }

    @Nonnull
    public Map<Long, Long> getOrderIdForCampaigns(int shard, Collection<Long> campaignIds) {
        return getOrderIdForCampaigns(dslContextProvider.ppc(shard), campaignIds);
    }
}
