package ru.yandex.direct.core.entity.bs.export.model

import com.fasterxml.jackson.annotation.JsonIgnore
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty

/**
 * Модель для передачи id ассетов, привязанных к баннеру в заданной кампании
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
data class AssetHashes(
    @JsonIgnore val bannerId: Long,
    @JsonIgnore val campaignId: Long,
    @JsonProperty("TitleAssetHash") val titleContentId: String?,
    @JsonProperty("TextBodyAssetHash") val textContentId: String?,
    @JsonProperty("ImageAssetHash") val imageContentId: String?,
    @JsonProperty("VideoAssetHash") val videoContentId: String?,
    @JsonProperty("Html5AssetHash") val html5ContentId: String?,
)
