package ru.yandex.direct.core.entity.bs.export.model;

/**
 * Спецификация воркера экспорта - id и тип.
 *
 * <a href="https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/protected/BS/Export/Queues.pm">Первоисточник</a>
 */
/* Однострочник для генерации:
perl -Mmy_inc=for,protected -MBS::Export::Queues -le 'my $q = \%BS::Export::Queues::QUEUES;
for my $i (sort {$a <=> $b} keys %$q) {
my $el = $q->{$i}; my $type = uc($el->{type});
print "${type}_$el->{order}($i, WorkerType.$type),"}'
*/
public enum WorkerSpec {
    STD_1(1, WorkerType.STD),
    STD_2(2, WorkerType.STD),
    STD_3(3, WorkerType.STD),
    STD_4(4, WorkerType.STD),
    STD_5(5, WorkerType.STD),
    STD_6(6, WorkerType.STD),
    STD_7(7, WorkerType.STD),
    STD_8(8, WorkerType.STD),
    STD_9(9, WorkerType.STD),
    STD_10(10, WorkerType.STD),
    STD_11(101, WorkerType.STD),
    STD_12(102, WorkerType.STD),
    STD_13(103, WorkerType.STD),
    STD_14(104, WorkerType.STD),
    STD_15(105, WorkerType.STD),
    STD_16(106, WorkerType.STD),
    STD_17(107, WorkerType.STD),
    STD_18(108, WorkerType.STD),
    STD_19(109, WorkerType.STD),
    STD_20(110, WorkerType.STD),
    STD_21(111, WorkerType.STD),
    STD_22(112, WorkerType.STD),
    STD_23(113, WorkerType.STD),
    STD_24(114, WorkerType.STD),
    STD_25(115, WorkerType.STD),

    STDPRICE_1(20, WorkerType.STDPRICE),
    STDPRICE_2(21, WorkerType.STDPRICE),
    STDPRICE_3(22, WorkerType.STDPRICE),
    STDPRICE_4(23, WorkerType.STDPRICE),
    STDPRICE_5(24, WorkerType.STDPRICE),
    STDPRICE_6(25, WorkerType.STDPRICE),
    STDPRICE_7(26, WorkerType.STDPRICE),
    STDPRICE_8(27, WorkerType.STDPRICE),
    STDPRICE_9(28, WorkerType.STDPRICE),
    STDPRICE_10(29, WorkerType.STDPRICE),

    HEAVY_1(30, WorkerType.HEAVY),
    HEAVY_2(31, WorkerType.HEAVY),
    HEAVY_3(32, WorkerType.HEAVY),
    HEAVY_4(33, WorkerType.HEAVY),
    HEAVY_5(34, WorkerType.HEAVY),
    HEAVY_6(35, WorkerType.HEAVY),
    HEAVY_7(36, WorkerType.HEAVY),
    HEAVY_8(37, WorkerType.HEAVY),
    HEAVY_9(38, WorkerType.HEAVY),
    HEAVY_10(39, WorkerType.HEAVY),
    HEAVY_11(141, WorkerType.HEAVY),
    HEAVY_12(142, WorkerType.HEAVY),
    HEAVY_13(143, WorkerType.HEAVY),
    HEAVY_14(144, WorkerType.HEAVY),
    HEAVY_15(145, WorkerType.HEAVY),
    HEAVY_16(146, WorkerType.HEAVY),
    HEAVY_17(147, WorkerType.HEAVY),
    HEAVY_18(148, WorkerType.HEAVY),


    CAMP_1(11, WorkerType.CAMP),

    CAMPS_ONLY_1(16, WorkerType.CAMPS_ONLY),

    FAST_1(41, WorkerType.FAST),

    DEV1_1(51, WorkerType.DEV1),
    DEVPRICE1_1(81, WorkerType.DEVPRICE1),

    DEV2_1(56, WorkerType.DEV2),
    DEVPRICE2_1(86, WorkerType.DEVPRICE2),

    PREPROD_1(75, WorkerType.PREPROD),

    BUGGY_1(91, WorkerType.BUGGY),
    BUGGY_2(92, WorkerType.BUGGY),

    INTERNAL_ADS_1(121, WorkerType.INTERNAL_ADS),

    FULL_LB_EXPORT_1(210, WorkerType.FULL_LB_EXPORT),
    FULL_LB_EXPORT_2(211, WorkerType.FULL_LB_EXPORT),
    FULL_LB_EXPORT_3(212, WorkerType.FULL_LB_EXPORT),
    FULL_LB_EXPORT_4(213, WorkerType.FULL_LB_EXPORT),
    FULL_LB_EXPORT_5(214, WorkerType.FULL_LB_EXPORT),
    FULL_LB_EXPORT_6(215, WorkerType.FULL_LB_EXPORT),
    FULL_LB_EXPORT_7(216, WorkerType.FULL_LB_EXPORT),
    FULL_LB_EXPORT_8(217, WorkerType.FULL_LB_EXPORT),
    FULL_LB_EXPORT_9(218, WorkerType.FULL_LB_EXPORT),
    FULL_LB_EXPORT_10(219, WorkerType.FULL_LB_EXPORT),

    // зарезервированные par_id, без воркеров
    MASTER(99, WorkerType.MASTER),
    NOSEND_FOR_DROP_SANDBOX_CLIENT(201, WorkerType.NOSEND);

    private final WorkerType workerType;
    private final int workerId;

    WorkerSpec(int workerId, WorkerType workerType) {
        this.workerId = workerId;
        this.workerType = workerType;
    }

    public WorkerType getWorkerType() {
        return workerType;
    }

    public long getWorkerId() {
        return workerId;
    }
}
