package ru.yandex.direct.core.entity.bs.resync.queue.model;

import java.util.Map;
import java.util.function.Function;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

/**
 * Именованные значения приоритета для bs_export_queue - очереди ленивой переотправки в БК.
 * <p>
 * При добавлении новых значения - пожалуйста дублируйте их в perl-версии, так как они используются для отображения
 * на странице "Администрирования" "Очереди экспорта в БК"
 *
 * @see <a href="https://svn.yandex-team.ru/websvn/wsvn/direct/trunk/protected/BS/ResyncQueue.pm">BS::ResyncQueue</a>
 */
public enum BsResyncPriority {
    // пожалуйста, сохраняйте сортировку по убыванию приоритета
    UNARC_CAMP_IN_BS_ON_NOTIFY_ORDER2(119),
    RESEND_DOMAINS_WITH_BLOCKED_TITLE(109),
    PRIORITY_ONE_SHOT_CAMP_STRATEGY_UPGRADE(103),
    INTERNAL_REPORTS_FAST_RESYNC(102),
    INTAPI_RESYNC_CAMPAIGNS(101),
    SYNC_AGGREGATOR_DOMAINS(96),
    MULTICURRENCY_SUMS_UPDATED(95),
    NDSDISCOUNT_GRAPH_CHANGED(93),
    ON_BILLING_AGGREGATE_ADDED(92),
    ON_CHANGED_RETARGETING_ACCESSIBILITY(90),
    PRIORITY_RESEND_SUSPENDED_VIDEO(80),
    UPDATE_DOMAIN_RATINGS(75),
    UPDATE_BANNER_WITH_ADDITIONS(56),
    ON_MOBILE_CONTENT_CHANGED(55),
    MANUAL_DOMAIN_MIRROR_CORRECTION(54),
    /**
     * <a href="https://st.yandex-team.ru/DIRECT-68145"></a>
     */
    PRIORITY_ONE_SHOT_RESYNC_BANNERS_ON_BR_FIX(51),
    INTERNAL_REPORTS_LAZY_RESYNC(50),
    RESEND_DOMAINS_BS(40),
    SAVE_CONTEXT_CATEGORIES_SEARCH_STOP(30),
    CHANGE_CAMP_CONTENT_LANG(29),
    PRIORITY_UPDATE_VCARD_PERMALINKS(28),
    CATALOGIA_BANNER_RUBRICS(26),
    SAVE_CONTEXT_CATEGORIES_DEFAULT(25),
    UPDATE_DOMAIN_VCARDS(20),
    RESYNC_WHOLE_CONTEXT_FOR_ABSENT_BID(12),
    DEFAULT_WHOLE_CAMP(3),
    /**
     * Умолчание, если непонятно какой приоритет нужен и хочется переотправить только кампанию.
     * Отправка самой кампании обычно важнее, чем её групп и баннеров, поэтому приоритет выше {@link #DEFAULT}
     */
    DEFAULT_CAMPS(2),
    /**
     * Умолчание, если непонятно какой приоритет нужен
     */
    DEFAULT(1),
    MAINTENANCE_PREPARE_RESYNC_FILE(-3),
    MAINTENANCE_FIX_VCARD_GEO_ID(-20),
    ONE_SHOT_FIX_MISSING_IMAGE_FORMATS(-21),
    ONE_SHOT_FIX_MODERATION_FLAGS(-74),
    ;

    private long value;

    BsResyncPriority(int value) {
        this.value = value;
    }

    public long value() {
        return value;
    }

    private static final Map<Long, BsResyncPriority> PRIORITIES = StreamEx.of(values())
            .mapToEntry(BsResyncPriority::value, Function.identity())
            // игнорируем дубли, это проверяется юнит-тестом
            .collapseKeys((a, b) -> a)
            .toImmutableMap();

    /**
     * Попробовать получить константу приоритета по его значению
     *
     * @param value значение приоритета
     * @return именованная константа или {@code null}, если соответствующего значения найдено не было
     */
    @Nullable
    public static BsResyncPriority tryParse(long value) {
        return PRIORITIES.get(value);
    }
}
