package ru.yandex.direct.core.entity.calltrackingphone.repository;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.util.mysql.MySQLDSL;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.calltracking.model.CalltrackingPhone;
import ru.yandex.direct.dbschema.ppcdict.tables.records.CalltrackingPhonesRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.dbschema.ppcdict.tables.CalltrackingPhones.CALLTRACKING_PHONES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Repository
@ParametersAreNonnullByDefault
public class CalltrackingPhoneRepository {
    private final DslContextProvider dslContextProvider;
    private final JooqMapperWithSupplier<CalltrackingPhone> mapper = createMapper();

    public CalltrackingPhoneRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    private static JooqMapperWithSupplier<CalltrackingPhone> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(CalltrackingPhone::new)
                .map(property(CalltrackingPhone.PHONE, CALLTRACKING_PHONES.PHONE))
                .map(property(CalltrackingPhone.LAST_UPDATE, CALLTRACKING_PHONES.LAST_UPDATE))
                .build();
    }

    public void addOrUpdate(Collection<CalltrackingPhone> calltrackingPhones) {
        InsertHelper<CalltrackingPhonesRecord> insertHelper =
                new InsertHelper<>(dslContextProvider.ppcdict(), CALLTRACKING_PHONES)
                        .addAll(mapper, calltrackingPhones);

        if (insertHelper.hasAddedRecords()) {
            insertHelper
                    .onDuplicateKeyUpdate()
                    .set(CALLTRACKING_PHONES.LAST_UPDATE, MySQLDSL.values(CALLTRACKING_PHONES.LAST_UPDATE));
        }

        insertHelper.executeIfRecordsAdded();
    }

    public int deleteOlderThan(LocalDateTime olderThan) {
        return dslContextProvider.ppcdict()
                .deleteFrom(CALLTRACKING_PHONES)
                .where(CALLTRACKING_PHONES.LAST_UPDATE.lt(olderThan))
                .execute();
    }

    /**
     *  Возвращает те номера из переданного списка, что есть в таблице calltracking_phones
     */
    public Set<String> remainExistingPhones(Collection<String> phones) {
        return dslContextProvider.ppcdict()
                .select(CALLTRACKING_PHONES.PHONE)
                .from(CALLTRACKING_PHONES)
                .where(CALLTRACKING_PHONES.PHONE.in(phones))
                .fetchSet(CALLTRACKING_PHONES.PHONE);
    }
}
