package ru.yandex.direct.core.entity.calltrackingsettings.repository.mapper;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.calltracking.model.SettingsPhone;
import ru.yandex.direct.utils.DirectObjectMapper;
import ru.yandex.direct.utils.JsonUtils;

import static org.apache.commons.lang3.StringUtils.isBlank;

public class CalltrackingSettingsMapper {

    public static final LocalDateTime DEFAULT_LAST_UPDATE = LocalDateTime.of(2021, 2, 5, 0, 0);
    private static final String DESERIALIZATION_ERROR = "can not deserialize object from json";

    private static final DirectObjectMapper MAPPER = new DirectObjectMapper()
            .registerModule(JsonUtils.createLocalDateTimeModule());

    public static List<SettingsPhone> phonesToTrackFromJson(@Nullable String json) {
        if (isBlank(json)) {
            return Collections.emptyList();
        }
        if (json.contains("{")) {
            return Arrays.asList(fromJson(json, SettingsPhone[].class));
        } else {
            return Arrays.stream(fromJson(json, String[].class))
                    .map(p -> new SettingsPhone().withPhone(p).withCreateTime(DEFAULT_LAST_UPDATE))
                    .collect(Collectors.toList());
        }
    }

    @Nullable
    public static String phonesToTrackToJson(@Nullable List<SettingsPhone> phonesToTrack) {
        if (phonesToTrack == null || phonesToTrack.isEmpty()) {
            return "";
        }
        return toJson(phonesToTrack);
    }

    public static <T> T fromJson(String json, Class<T> type) {
        try {
            return MAPPER.readValue(json, type);
        } catch (IOException e) {
            throw new IllegalArgumentException(DESERIALIZATION_ERROR, e);
        }
    }

    public static String toJson(Object obj) {
        return MAPPER.writeValueAsString(obj);
    }
}
