package ru.yandex.direct.core.entity.calltrackingsettings.validation;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

public class CalltrackingSettingDefects {
    public static Defect<Void> noWritePermissionsOnCounter() {
        return new Defect<>(Ids.NO_WRITE_PERMISSIONS_ON_COUNTER);
    }

    public static Defect<Void> counterNotAvailableForClient() {
        return new Defect<>(Ids.COUNTER_NOT_AVAILABLE_FOR_CLIENT);
    }

    public static Defect<Void> forbiddenDomain() {
        return new Defect<>(Ids.FORBIDDEN_DOMAIN);
    }

    public enum Ids implements DefectId<Void> {
        NO_WRITE_PERMISSIONS_ON_COUNTER,
        COUNTER_NOT_AVAILABLE_FOR_CLIENT,
        FORBIDDEN_DOMAIN
    }
}
