package ru.yandex.direct.core.entity.campaign

import ru.yandex.direct.core.entity.campaign.model.CampaignSource
import ru.yandex.direct.dbschema.ppc.enums.CampaignsSource as DBCampaignSource

object AvailableCampaignSources {
    fun isSupportedInAPI5(source: CampaignSource): Boolean {
        return !UNSUPPORTED_IN_API5.contains(source)
    }

    fun isUC(source: CampaignSource?): Boolean {
        if (source == null) {
            return false
        }

        return UNIVERSAL_CAMPAIGN_SOURCES.contains(source)
    }

    fun isUC(source: DBCampaignSource?): Boolean {
        if (source == null) {
            return false
        }

        return isUC(CampaignSource.fromSource(source))
    }

    fun ucSources(): Set<CampaignSource> {
        return UNIVERSAL_CAMPAIGN_SOURCES
    }

    private val UNSUPPORTED_IN_API5 = setOf(
        CampaignSource.UAC, CampaignSource.ZEN, CampaignSource.WIDGET
    )

    private val UNIVERSAL_CAMPAIGN_SOURCES = setOf(
        CampaignSource.UAC, CampaignSource.WIDGET
    )
}
