package ru.yandex.direct.core.entity.campaign

import ru.yandex.direct.autobudget.restart.model.StrategyDto
import ru.yandex.direct.autobudget.restart.service.AutobudgetRestartService
import ru.yandex.direct.core.entity.campaign.model.CampOptionsStrategy
import ru.yandex.direct.core.entity.campaign.model.CampaignWithDayBudget
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.CampaignWithStrategy
import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.libs.timetarget.TimeTargetUtils

object CampaignAutobudgetRestartUtils {

    fun getStrategyDto(
        campaign: CommonCampaign,
        hasMoney: Boolean,
        hasCombinedGoals: Boolean
    ): StrategyDto {
        var dto = StrategyDto(
            timeTarget = if (campaign.timeTarget == null || campaign.timeTarget == TimeTargetUtils.defaultTimeTarget())
                null
            else campaign.timeTarget.originalTimeTarget,
            startTime = campaign.startDate ?: AutobudgetRestartService.OLD_START_TIME,
            finishTime = campaign.endDate,
            enableCpcHold = campaign.enableCpcHold,
            statusShow = campaign.statusShow,
            hasMoney = hasMoney,
            strategy = if (campaign is CampaignWithStrategy) campaign.strategy.strategyData.name else "default",
            strategyId = (campaign as? CampaignWithPackageStrategy)?.strategyId,
            hasCombinedGoals = hasCombinedGoals,
            dayBudget = if (campaign is CampaignWithDayBudget) campaign.dayBudget else null,
        )
        if (campaign is CampaignWithStrategy) {
            dto = dto.copy(
                payForConversion = campaign.strategy.strategyData.payForConversion,
                goalId = campaign.strategy.strategyData.goalId,
                roiCoef = campaign.strategy.strategyData.roiCoef,
                avgCpm = campaign.strategy.strategyData.avgCpm,
                avgBid = campaign.strategy.strategyData.avgBid,
                avgCpa = campaign.strategy.strategyData.avgCpa,
                avgCpv = campaign.strategy.strategyData.avgCpv,
                strategyStart = campaign.strategy.strategyData.start,
                strategyFinish = campaign.strategy.strategyData.finish,
                platform = CampaignsPlatform.toSource(campaign.strategy.platform)?.literal,
                autoBudgetSum = campaign.strategy.strategyData.sum,
                manualStrategy = CampOptionsStrategy.toSource(campaign.strategy.strategy)?.literal,
                limitClicks = campaign.strategy.strategyData.limitClicks,
            )
        }
        return dto
    }
}
