package ru.yandex.direct.core.entity.campaign;

import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignSource;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@ParametersAreNonnullByDefault
public class CampaignUtils {
    private CampaignUtils() {
    }

    public static final Set<CampaignType> CPM_TYPES =
            Set.of(CampaignType.CPM_DEALS, CampaignType.CPM_BANNER,
                    CampaignType.CPM_PRICE, CampaignType.CPM_YNDX_FRONTPAGE);

    /**
     * Правда ли, что кампания заведена в Директе. Если source null, то считаем, что это тоже Директ.
     * @param source источник, где заведена кампания
     * @return Директ или нет
     */
    public static boolean isDirectSource(@Nullable CampaignSource source) {
        return source == null || CampaignSource.DIRECT == source;
    }

    public static List<String> getDisabledDomains(List<String> knownSsp, List<String> disabledPlaces) {
        return filterList(disabledPlaces, place -> knownSsp.stream()
                .noneMatch(s -> s.equalsIgnoreCase(place)));
    }
}
