package ru.yandex.direct.core.entity.campaign;

import java.math.BigDecimal;

import ru.yandex.direct.currency.Money;

public class MediaCampaignUtil {
    private MediaCampaignUtil() {
    }

    /**
     * Рассчитать для Баяна фиктивную истраченную в деньгах сумму пропорционально использованным показам
     * Это нужно, чтобы при изменении цены продукта (куплен по старой цене, тратится по новой) sum сходился с sum_spent
     * В Баяне sum и sum_spent использоваться не должны, но используются в проверках на наличие денег на заказе
     *
     * @param sum           оплаченная сумма на кампании
     * @param sumSpentUnits всего потрачено показов
     * @param sumUnits      всего оплачено показов
     */
    public static BigDecimal calcMediaSumSpent(Money sum, long sumSpentUnits, long sumUnits) {
        if (sumUnits == sumSpentUnits) {
            return sum.bigDecimalValue();
        } else if (sumUnits == 0) {
            return BigDecimal.ZERO;
        } else {
            BigDecimal sumSpentUnitsBd = BigDecimal.valueOf(sumSpentUnits);
            BigDecimal sumUnitsBd = BigDecimal.valueOf(sumUnits);
            return sum.multiply(sumSpentUnitsBd)
                    .divide(sumUnitsBd)
                    .bigDecimalValue();
        }
    }
}
