package ru.yandex.direct.core.entity.campaign

import org.slf4j.LoggerFactory
import org.slf4j.helpers.MessageFormatter
import org.springframework.stereotype.Component
import ru.yandex.direct.common.logging.LogRecord
import ru.yandex.direct.core.entity.campaign.model.PlacementType
import ru.yandex.direct.tracing.Trace
import ru.yandex.direct.utils.JsonUtils

@Component
class PlacementTypesChangeLogger {
    private val changeLogger = LoggerFactory.getLogger("PPCLOG_CMD.log")

    fun log(operatorUid: Long, campaignId: Long, oldState: Set<PlacementType>?, newState: Set<PlacementType>?) {
        val logRecord = PlacementTypesChangeLogRecord(operatorUid, campaignId, oldState, newState)
        changeLogger.info(logRecord.formatLogRecord())
    }
}

class PlacementTypesChangeLogRecord(
    operatorUid: Long, campaignId: Long,
    oldState: Set<PlacementType>?,
    newState: Set<PlacementType>?
) : LogRecord(Trace.current().traceId) {

    companion object {
        private const val LOG_SERVICE_NAME = "direct.java.core"
        private const val LOG_CMD_NAME = "_save_placement_types"
    }

    init {
        path = LOG_CMD_NAME
        setOperatorId(operatorUid)
        cids = listOf(campaignId)
        param["cid"] = campaignId
        param["old_placement_types"] = oldState
        param["new_placement_types"] = newState
    }


    override fun getService(): String {
        return LOG_SERVICE_NAME
    }

    fun formatLogRecord(): String {
        return MessageFormatter.format("{} {}", prefixLogTime, JsonUtils.toJson(this)).message
    }
}
