package ru.yandex.direct.core.entity.campaign.container

import org.jooq.Condition
import org.jooq.impl.DSL
import ru.yandex.direct.core.entity.campaign.model.ApiCampaignPaymentStatus
import ru.yandex.direct.core.entity.campaign.model.ApiCampaignState
import ru.yandex.direct.core.entity.campaign.model.ApiCampaignStatus
import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.model.toCondition
import ru.yandex.direct.core.entity.campaign.model.toDbStatusModerate
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.dbschema.ppc.enums.CampaignsSource
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusempty
import ru.yandex.direct.multitype.repository.filter.ConditionFilter

data class ApiCampaignsSelectionCriteria(
    val ids: Collection<Long>,
    val types: Set<CampaignType>,
    val states: Set<ApiCampaignState>,
    val statuses: Set<ApiCampaignStatus>,
    val paymentStatuses: Set<ApiCampaignPaymentStatus>,
    val withoutConvertedCampaigns: Boolean,
) {
    fun toCondition(): Condition {
        val conditions: List<Condition> = buildList {
            add(CAMPAIGNS.STATUS_EMPTY.eq(CampaignsStatusempty.No))
            add(CAMPAIGNS.SOURCE.notIn(CampaignsSource.uac, CampaignsSource.widget))
            add(CAMPAIGNS.CID.`in`(ids))

            if (types.isNotEmpty()) {
                val dbTypes = types.map(CampaignType::toSource)
                add(CAMPAIGNS.TYPE.`in`(dbTypes))
            }

            if (states.isNotEmpty()) {
                val stateConditions = states.map { it.toCondition() }
                add(DSL.or(stateConditions))
            }

            if (withoutConvertedCampaigns) {
                val convertedCondition = ApiCampaignState.CONVERTED.toCondition()
                add(DSL.not(convertedCondition))
            }

            if (statuses.isNotEmpty()) {
                val moderateStatuses = statuses.flatMap { it.toDbStatusModerate() }
                add(CAMPAIGNS.STATUS_MODERATE.`in`(moderateStatuses))
            }

            if (paymentStatuses.isNotEmpty()) {
                val paymentConditions = paymentStatuses.map { it.toCondition() }
                add(DSL.or(paymentConditions))
            }
        }

        return DSL.and(conditions)
    }

    fun toConditionFilter(): ConditionFilter =
        object : ConditionFilter() {
            override fun isEmpty(): Boolean = false

            override fun getCondition(): Condition =
                this@ApiCampaignsSelectionCriteria.toCondition()
        }
}
