package ru.yandex.direct.core.entity.campaign.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.autobudget.service.AlertsFreezeInfo;
import ru.yandex.direct.core.entity.balance.model.BalanceNotificationInfo;
import ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncPriority;
import ru.yandex.direct.core.entity.mailnotification.model.GenericEvent;

/**
 * Контейнер с данными, для выполнения доролнительных действий в операциях кампаний.
 * Например для сброса статуса синхронизации с БК для групп и баннеров
 * Или добавления в очередь на отправку нотификаций в Баланс
 */
@ParametersAreNonnullByDefault
public class CampaignAdditionalActionsContainer {

    private final Set<Long> campaignIdsForResetBannersStatusBsSynced;
    private final Set<Long> campaignIdsForResetBannersStatusBsSyncedAndUpdateLastChange;
    private final Set<Long> campaignIdsForUpdateBannersLastChange;
    private final Set<Long> campaignIdsForUpdateAdGroupStatusShowsForecast;
    private final Set<Long> campaignIdsForResetAdGroupStatusBsSynced;
    private final Set<Long> campaignIdsForMarkAggregatedStatusesAsObsolete;
    private final Map<Long, BsResyncPriority> campaignIdsWithPriorityForAddBannersToBsResyncQueue;
    private final List<BalanceNotificationInfo> balanceNotifications;
    private final List<GenericEvent> mailEvents;
    private final Set<Long> campaignsToFreezeAlerts;
    private final Set<Long> campaignsToFreezeCpaAlerts;

    public CampaignAdditionalActionsContainer() {
        this.campaignIdsForResetBannersStatusBsSynced = new HashSet<>();
        this.campaignIdsForResetBannersStatusBsSyncedAndUpdateLastChange = new HashSet<>();
        this.campaignIdsForUpdateBannersLastChange = new HashSet<>();
        this.campaignIdsForUpdateAdGroupStatusShowsForecast = new HashSet<>();
        this.campaignIdsForResetAdGroupStatusBsSynced = new HashSet<>();
        this.campaignIdsForMarkAggregatedStatusesAsObsolete = new HashSet<>();
        this.campaignIdsWithPriorityForAddBannersToBsResyncQueue = new HashMap<>();
        this.balanceNotifications = new ArrayList<>();
        this.mailEvents = new ArrayList<>();
        this.campaignsToFreezeAlerts = new HashSet<>();
        this.campaignsToFreezeCpaAlerts = new HashSet<>();
    }

    public void resetCampaignAdGroupsStatusBsSynced(Collection<Long> campaignIds) {
        campaignIdsForResetAdGroupStatusBsSynced.addAll(campaignIds);
    }

    public Set<Long> getCampaignIdsForResetAdGroupStatusBsSynced() {
        return campaignIdsForResetAdGroupStatusBsSynced;
    }

    public void resetCampaignBannersStatusBsSynced(Collection<Long> campaignIds) {
        campaignIdsForResetBannersStatusBsSynced.addAll(campaignIds);
    }

    public Set<Long> getCampaignIdsForResetBannersStatusBsSynced() {
        return Set.copyOf(campaignIdsForResetBannersStatusBsSynced);
    }

    public void resetCampaignBannersStatusBsSyncedAndUpdateLastChange(Collection<Long> campaignIds) {
        campaignIdsForResetBannersStatusBsSyncedAndUpdateLastChange.addAll(campaignIds);
    }

    public Set<Long> getCampaignIdsForResetBannersStatusBsSyncedAndUpdateLastChange() {
        return Set.copyOf(campaignIdsForResetBannersStatusBsSyncedAndUpdateLastChange);
    }

    public void addCampaignIdsForUpdateStatusShowsForecast(Collection<Long> campaignIds) {
        campaignIdsForUpdateAdGroupStatusShowsForecast.addAll(campaignIds);
    }

    public Set<Long> getCampaignIdsForUpdateAdGroupStatusShowsForecast() {
        return Set.copyOf(campaignIdsForUpdateAdGroupStatusShowsForecast);
    }

    public void addCampaignIdsForUpdateBannersLastChange(Collection<Long> campaignIds) {
        campaignIdsForUpdateBannersLastChange.addAll(campaignIds);
    }

    public Set<Long> getCampaignIdsForUpdateBannersLastChange() {
        return Set.copyOf(campaignIdsForUpdateBannersLastChange);
    }

    public void addCampaignIdsForMarkAggregatedStatusesAsObsolete(Collection<Long> campaignIds) {
        campaignIdsForMarkAggregatedStatusesAsObsolete.addAll(campaignIds);
    }

    public Set<Long> getCampaignIdsForMarkAggregatedStatusesAsObsolete() {
        return Set.copyOf(campaignIdsForMarkAggregatedStatusesAsObsolete);
    }

    public void addCampaignBannersToBsResyncQueue(BsResyncPriority priority, Set<Long> campaignIds) {
        campaignIds.forEach(campaignId -> {
            BsResyncPriority oldPriority = campaignIdsWithPriorityForAddBannersToBsResyncQueue.get(campaignId);
            if (oldPriority == null || oldPriority.value() < priority.value()) {
                // добавляем если кампании не было в мапе или приоритет меньше нового
                campaignIdsWithPriorityForAddBannersToBsResyncQueue.put(campaignId, priority);
            }
        });
    }

    public Map<Long, BsResyncPriority> getCampaignIdsWithPriorityForAddBannersToBsResyncQueue() {
        return Map.copyOf(campaignIdsWithPriorityForAddBannersToBsResyncQueue);
    }

    public void addBalanceNotificationToQueue(BalanceNotificationInfo balanceNotificationInfo) {
        balanceNotifications.add(balanceNotificationInfo);
    }

    public void addBalanceNotificationsToQueue(Collection<BalanceNotificationInfo> balanceNotificationInfos) {
        balanceNotifications.addAll(balanceNotificationInfos);
    }

    public List<BalanceNotificationInfo> getBalanceNotifications() {
        return List.copyOf(balanceNotifications);
    }

    public void addMailEventsToQueue(Collection<? extends GenericEvent> events) {
        mailEvents.addAll(events);
    }

    public List<GenericEvent> getMailEvents() {
        return List.copyOf(mailEvents);
    }

    public void addCampaignsToFreezeAlerts(AlertsFreezeInfo info) {
        campaignsToFreezeAlerts.addAll(info.getCampaignsToFreezeHourlyAlerts());
        campaignsToFreezeCpaAlerts.addAll(info.getCampaignsToFreezeCpaAlerts());
    }

    public Set<Long> getCampaignsToFreezeAlerts() {
        return Set.copyOf(campaignsToFreezeAlerts);
    }

    public Set<Long> getCampaignsToFreezeCpaAlerts() {
        return Set.copyOf(campaignsToFreezeCpaAlerts);
    }
}
