package ru.yandex.direct.core.entity.campaign.container;

import java.math.BigDecimal;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
public class CampaignStrategyChangingSettings {
    private final BigDecimal minPrice;
    private final BigDecimal maxPrice;

    private final boolean hasExtendedRelevanceMatch;

    private CampaignStrategyChangingSettings(BigDecimal minPrice,
                                             BigDecimal maxPrice,
                                             boolean hasExtendedRelevanceMatch) {
        checkArgument(minPrice.compareTo(maxPrice) < 0, "minPrice should");
        this.minPrice = minPrice;
        this.maxPrice = maxPrice;

        this.hasExtendedRelevanceMatch = hasExtendedRelevanceMatch;
    }

    public static CampaignStrategyChangingSettings create(BigDecimal minPrice,
                                                          BigDecimal maxPrice,
                                                          boolean hasExtendedRelevanceMatch) {
        return new CampaignStrategyChangingSettings(minPrice, maxPrice, hasExtendedRelevanceMatch);
    }

    public BigDecimal getMinPrice() {
        return minPrice;
    }

    public BigDecimal getMaxPrice() {
        return maxPrice;
    }

    public boolean isHasExtendedRelevanceMatch() {
        return hasExtendedRelevanceMatch;
    }
}
