package ru.yandex.direct.core.entity.campaign.container;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbschema.ppc.enums.CampaignsAutobudget;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.libs.timetarget.TimeTarget;

@ParametersAreNonnullByDefault
public class CampaignWithAutobudget {
    public final Long campaignId;
    @Nullable
    public final TimeTarget timeTarget;
    public final ClientId clientId;
    public final CampaignsAutobudget autobudget;

    public CampaignWithAutobudget(
            Long campaignId,
            @Nullable TimeTarget timeTarget,
            CampaignsAutobudget autobudget,
            ClientId clientId) {
        this.campaignId = campaignId;
        this.timeTarget = timeTarget;
        this.clientId = clientId;
        this.autobudget = autobudget;
    }
}
