package ru.yandex.direct.core.entity.campaign.container

import ru.yandex.direct.dbutil.model.ClientId

data class CampaignsCopySelectionCriteria(
    val clientId: ClientId,
    val campaignIds: List<Long>?,
    val selectionType: SelectionType?,
) {
    init {
        check((campaignIds == null) != (selectionType == null)) {
            "Either campaign ids or selection type should be provided, not both"
        }
    }

    enum class SelectionType {
        /**
         * Скопировать только активные кампании
         */
        ACTIVE,

        /**
         * Скопировать только остановленные кампании
         */
        STOPPED,

        /**
         * Скопировать только черновики
         */
        DRAFT,

        /**
         * Скопировать все архивные кампании
         */
        ARCHIVED,

        /**
         * Скопировать все кампании
         */
        ALL,
    }
}
