package ru.yandex.direct.core.entity.campaign.converter;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.campaign.model.BrandSurveyStopReason;

import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.utils.CommonUtils.nvl;

public final class BrandSurveyStopReasonsConverter {

    private BrandSurveyStopReasonsConverter() {
    }

    public static String toString(Set<BrandSurveyStopReason> brandLiftStopReasons) {
        return nvl(brandLiftStopReasons, EnumSet.noneOf(BrandSurveyStopReason.class))
                .stream()
                .map(e -> e.name().toLowerCase())
                .collect(joining(","));
    }

    public static EnumSet<BrandSurveyStopReason> fromString(String str) {
        if (str == null || "".equals(str)) {
            return EnumSet.noneOf(BrandSurveyStopReason.class);
        }

        return EnumSet.copyOf(
                List.of(str
                        .split(","))
                        .stream()
                        .distinct()
                        .map(name -> BrandSurveyStopReason.valueOf(name.toUpperCase()))
                        .collect(toList()));
    }
}
