package ru.yandex.direct.core.entity.campaign.converter;

import java.math.BigDecimal;

import ru.yandex.direct.core.entity.campaign.model.EshowsRate;
import ru.yandex.direct.core.entity.campaign.model.EshowsSettings;
import ru.yandex.direct.core.entity.campaign.model.EshowsVideoType;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class EshowsSettingsConverter {

    private EshowsSettingsConverter() {
    }

    public static EshowsSettings fromDbFormat(BigDecimal bannerRate, BigDecimal videoRate, String videoType) {
        return new EshowsSettings()
                .withBannerRate(toEshowsRate(bannerRate))
                .withVideoRate(toEshowsRate(videoRate))
                .withVideoType(ifNotNull(videoType, t -> EshowsVideoType.valueOf(t.toUpperCase())));
    }

    public static BigDecimal bannerRateToDb(EshowsSettings eshowsSettings) {
        return ifNotNull(eshowsSettings, s -> fromEshowsRate(s.getBannerRate()));
    }

    public static BigDecimal videoRateToDb(EshowsSettings eshowsSettings) {
        return ifNotNull(eshowsSettings, s -> fromEshowsRate(s.getVideoRate()));
    }

    public static String videoTypeToDb(EshowsSettings eshowsSettings) {
        return ifNotNull(ifNotNull(eshowsSettings, EshowsSettings::getVideoType), Enum::name);
    }

    private static EshowsRate toEshowsRate(BigDecimal bannerRate) {
        return ifNotNull(bannerRate, r -> EshowsRate.fromTypedValue(r.doubleValue()));
    }

    private static BigDecimal fromEshowsRate(EshowsRate eshowsRate) {
        return ifNotNull(eshowsRate, r -> BigDecimal.valueOf(r.getTypedValue()));
    }
}
