package ru.yandex.direct.core.entity.campaign.converter;

import java.util.List;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.GoalType;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionMappings;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class ExperimentsConverter {
    private ExperimentsConverter() {
    }

    @Nullable
    public static List<Long> sectionIdFromDb(@Nullable String record) {
        if (record == null) {
            return null;
        }

        List<Rule> rules = RetargetingConditionMappings.rulesFromJson(record);

        return mapList(rules, Rule::getSectionId);
    }

    @Nullable
    public static List<Long> abSegmentGoalsFromDb(@Nullable String record) {
        if (record == null) {
            return null;
        }

        List<Rule> rules = RetargetingConditionMappings.rulesFromJson(record);

        return StreamEx.of(rules)
                .map(Rule::getGoals)
                .flatMap(StreamEx::of)
                .filter(g -> g.getType() == GoalType.AB_SEGMENT)
                .map(Goal::getId)
                .toList();
    }
}
