package ru.yandex.direct.core.entity.campaign.converter;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.ImpressionStandardTime;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@ParametersAreNonnullByDefault
public class ImpressionStandardTimeConverter {

    private ImpressionStandardTimeConverter() {
    }

    public static ImpressionStandardTime fromDbFormat(Long impressionStandardTime) {
        return ifNotNull(impressionStandardTime, ImpressionStandardTime::fromTypedValue);
    }

    public static Long toDbFormat(ImpressionStandardTime impressionStandardTime) {
        return ifNotNull(impressionStandardTime, ImpressionStandardTime::getTypedValue);
    }
}
