package ru.yandex.direct.core.entity.campaign.converter;

import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.mobileapp.model.MobileAppAlternativeStore;
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppDeviceTypeTargeting;
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppNetworkTargeting;

public class MobileContentConverter {

    private MobileContentConverter() {

    }

    public static String deviceTypeTargetingToDb(Collection<MobileAppDeviceTypeTargeting> deviceTypeTargetings) {
        if (deviceTypeTargetings == null) {
            return null;
        }
        return deviceTypeTargetings.stream()
                .map(MobileAppDeviceTypeTargeting::getTypedValue)
                .collect(Collectors.joining(","));
    }

    public static EnumSet<MobileAppDeviceTypeTargeting> deviceTypeTargetingFromDb(String deviceTypeTargetings) {
        if (deviceTypeTargetings == null) {
            return null;
        }
        if (deviceTypeTargetings.trim().isEmpty()) {
            return EnumSet.noneOf(MobileAppDeviceTypeTargeting.class);
        }
        return StreamEx.split(deviceTypeTargetings, ",")
                .map(device -> MobileAppDeviceTypeTargeting.fromTypedValue(device.toLowerCase()))
                .collect(Collectors.toCollection(() -> EnumSet.noneOf(MobileAppDeviceTypeTargeting.class)));
    }

    public static String networkTargetingsToDb(Collection<MobileAppNetworkTargeting> networkTargetings) {
        if (networkTargetings == null) {
            return null;
        }
        return networkTargetings.stream()
                .map(MobileAppNetworkTargeting::getTypedValue)
                .collect(Collectors.joining(","));
    }

    public static EnumSet<MobileAppNetworkTargeting> networkTargetingsFromDb(String networkTargetings) {
        if (networkTargetings == null) {
            return null;
        }
        if (networkTargetings.trim().isEmpty()) {
            return EnumSet.noneOf(MobileAppNetworkTargeting.class);
        }
        return StreamEx.split(networkTargetings, ",")
                .map(network -> MobileAppNetworkTargeting.fromTypedValue(network.toLowerCase()))
                .collect(Collectors.toCollection(() -> EnumSet.noneOf(MobileAppNetworkTargeting.class)));
    }

    public static String altAppStoresToDb(Collection<MobileAppAlternativeStore> altAppStores) {
        if (altAppStores == null) {
            return null;
        }
        return altAppStores.stream()
                .map(MobileAppAlternativeStore::getTypedValue)
                .collect(Collectors.joining(","));
    }

    public static EnumSet<MobileAppAlternativeStore> altAppStoresFromDb(String altAppStores) {
        if (altAppStores == null) {
            return null;
        }
        if (altAppStores.trim().isEmpty()) {
            return EnumSet.noneOf(MobileAppAlternativeStore.class);
        }
        return StreamEx.split(altAppStores, ",")
                .map(network -> MobileAppAlternativeStore.fromTypedValue(network.toLowerCase()))
                .collect(Collectors.toCollection(() -> EnumSet.noneOf(MobileAppAlternativeStore.class)));
    }
}
