package ru.yandex.direct.core.entity.campaign.converter;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.campaign.model.PriceFlightReasonIncorrect;
import ru.yandex.direct.core.entity.campaign.model.PriceFlightStatusApprove;
import ru.yandex.direct.core.entity.campaign.model.PriceFlightStatusCorrect;
import ru.yandex.direct.core.entity.campaign.model.PriceFlightTargetingsSnapshot;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsCpmPriceStatusApprove;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsCpmPriceStatusCorrect;
import ru.yandex.direct.utils.JsonUtils;

public class PriceFlightConverter {

    public static String targetingsSnapshotToDbFormat(PriceFlightTargetingsSnapshot targetingsSnapshot) {
        return JsonUtils.toJson(targetingsSnapshot);
    }

    public static PriceFlightTargetingsSnapshot targetingsSnapshotFromDbFormat(String targetingsSnapshotJson) {
        return targetingsSnapshotJson == null ? null
                : JsonUtils.fromJson(targetingsSnapshotJson, PriceFlightTargetingsSnapshot.class);
    }

    public static Boolean autoProlongationtFromDbFormat(String strategyData) {
        return strategyData == null ? null
                : RepositoryUtils.booleanFromLong(JsonUtils.fromJson(strategyData, StrategyData.class).getAutoProlongation());
    }

    public static CampaignsCpmPriceStatusApprove statusApproveToDbFormat(PriceFlightStatusApprove value) {
        return PriceFlightStatusApprove.toSource(value);
    }

    public static PriceFlightStatusApprove statusApproveFromDbFormat(CampaignsCpmPriceStatusApprove value) {
        return PriceFlightStatusApprove.fromSource(value);
    }

    public static CampaignsCpmPriceStatusCorrect statusCorrectToDbFormat(PriceFlightStatusCorrect value) {
        return PriceFlightStatusCorrect.toSource(value);
    }

    public static PriceFlightStatusCorrect statusCorrectFromDbFormat(CampaignsCpmPriceStatusCorrect value) {
        return PriceFlightStatusCorrect.fromSource(value);
    }

    public static String reasonIncorrectToDbFormat(PriceFlightReasonIncorrect reasonIncorrect) {
        return reasonIncorrect == null ? null : reasonIncorrect.name();
    }

    public static PriceFlightReasonIncorrect reasonIncorrectFromDbFormat(String reasonIncorrectText) {
        return reasonIncorrectText == null ? null : PriceFlightReasonIncorrect.valueOf(reasonIncorrectText);
    }

}
