package ru.yandex.direct.core.entity.campaign.model

import org.jooq.Condition
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusmoderate

/**
 * Готовность кампании к оплате (для API Campaigns)
 *
 * [Документация](https://yandex.ru/dev/direct/doc/dg/objects/campaign.html#status)
 */
enum class ApiCampaignPaymentStatus {
    DISALLOWED,
    ALLOWED,
}

fun ApiCampaignPaymentStatus.toCondition(): Condition =
    when (this) {
        ApiCampaignPaymentStatus.DISALLOWED ->
            Tables.CAMPAIGNS.STATUS_MODERATE.`in`(
                statusesModerateWithDisallowedPayment.map(CampaignStatusModerate::toSource)
            ).and(Tables.CAMPAIGNS.WALLET_CID.eq(0))

        ApiCampaignPaymentStatus.ALLOWED ->
            Tables.CAMPAIGNS.STATUS_MODERATE.eq(CampaignsStatusmoderate.Yes)
                .or(Tables.CAMPAIGNS.WALLET_CID.ne(0))
    }

private val statusesModerateWithDisallowedPayment = listOf(
    CampaignStatusModerate.SENT,
    CampaignStatusModerate.READY,
    CampaignStatusModerate.NO,
    CampaignStatusModerate.NEW,
)
