package ru.yandex.direct.core.entity.campaign.model

import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusmoderate

/**
 * Результат модерации объектов кампании (для API Campaigns)
 *
 * [Документация](https://yandex.ru/dev/direct/doc/dg/objects/campaign.html#status)
 */
enum class ApiCampaignStatus {
    ACCEPTED,
    DRAFT,
    MODERATION,
    REJECTED,
}

fun ApiCampaignStatus.toDbStatusModerate(): List<CampaignsStatusmoderate> =
    when (this) {
        ApiCampaignStatus.ACCEPTED ->
            listOf(CampaignsStatusmoderate.Yes)

        ApiCampaignStatus.DRAFT ->
            listOf(CampaignsStatusmoderate.New)

        ApiCampaignStatus.MODERATION ->
            listOf(CampaignsStatusmoderate.Sent, CampaignsStatusmoderate.Ready)

        ApiCampaignStatus.REJECTED ->
            listOf(CampaignsStatusmoderate.No)
    }
