package ru.yandex.direct.core.entity.campaign.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class BrandSurveyStatus {

    private SurveyStatus surveyStatusDaily;

    private List<Long> reasonIds;

    private Set<BrandSurveyStopReason> brandSurveyStopReasonsDaily;

    private BigDecimal sumSpentByDay;

    private BigDecimal sumSpentByTotalPeriod;

    private BasicUplift basicUplift;

    public BrandSurveyStatus() {
    }

    public SurveyStatus getSurveyStatusDaily() {
        return surveyStatusDaily;
    }

    public void setSurveyStatusDaily(SurveyStatus surveyStatusDaily) {
        this.surveyStatusDaily = surveyStatusDaily;
    }

    public BrandSurveyStatus withSurveyStatusDaily(SurveyStatus surveyStatusDaily) {
        this.surveyStatusDaily = surveyStatusDaily;
        return this;
    }

    public List<Long> getReasonIds() {
        return reasonIds;
    }

    public void setReasonIds(List<Long> reasonIds) {
        this.reasonIds = reasonIds;
    }

    public BrandSurveyStatus withReasonIds(List<Long> reasonIds) {
        this.reasonIds = reasonIds;
        return this;
    }

    public Set<BrandSurveyStopReason> getBrandSurveyStopReasonsDaily() {
        return brandSurveyStopReasonsDaily;
    }

    public void setBrandSurveyStopReasonsDaily(Set<BrandSurveyStopReason> brandSurveyStopReasonsDaily) {
        this.brandSurveyStopReasonsDaily = brandSurveyStopReasonsDaily;
    }

    public BrandSurveyStatus withBrandSurveyStopReasonsDaily(Set<BrandSurveyStopReason> brandSurveyStopReasonsDaily) {
        this.brandSurveyStopReasonsDaily = brandSurveyStopReasonsDaily;
        return this;
    }

    public BigDecimal getSumSpentByDay() {
        return sumSpentByDay;
    }

    public void setSumSpentByDay(BigDecimal sumSpentByDay) {
        this.sumSpentByDay = sumSpentByDay;
    }

    public BrandSurveyStatus withSumSpentByDay(BigDecimal sumSpentByDay) {
        this.sumSpentByDay = sumSpentByDay;
        return this;
    }

    public BigDecimal getSumSpentByTotalPeriod() {
        return sumSpentByTotalPeriod;
    }

    public BrandSurveyStatus withSumSpentByTotalPeriod(BigDecimal sumSpentByTotalPeriod) {
        this.sumSpentByTotalPeriod = sumSpentByTotalPeriod;
        return this;
    }

    public BasicUplift getBasicUplift() {
        return basicUplift;
    }

    public void setBasicUplift(BasicUplift basicUplift) {
        this.basicUplift = basicUplift;
    }

    public BrandSurveyStatus withBasicUplift(BasicUplift basicUplift) {
        this.basicUplift = basicUplift;
        return this;
    }
}
