package ru.yandex.direct.core.entity.campaign.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.ytwrapper.model.YtTableRow;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

@ParametersAreNonnullByDefault
public class BrandSurveyStatusRow extends YtTableRow {

    private String brandSurveyId;
    private String state;
    private String moderationState;
    private YTreeNode moderationReasons;
    private YTreeNode stopReasons;
    private YTreeNode basicUplift;

    public String getState() {
        return state;
    }

    public BrandSurveyStatusRow withState(String state) {
        this.state = state;
        return this;
    }

    public String getModerationState() {
        return moderationState;
    }

    public BrandSurveyStatusRow withModerationState(String moderationState) {
        this.moderationState = moderationState;
        return this;
    }

    public YTreeNode getModerationReasons() {
        return moderationReasons;
    }

    public BrandSurveyStatusRow withModerationReasons(YTreeNode moderationReasons) {
        this.moderationReasons = moderationReasons;
        return this;
    }

    public YTreeNode getStopReasons() {
        return stopReasons;
    }

    public BrandSurveyStatusRow withStopReasons(YTreeNode stopReasons) {
        this.stopReasons = stopReasons;
        return this;
    }

    public String getBrandSurveyId() {
        return brandSurveyId;
    }

    public BrandSurveyStatusRow withBrandSurveyId(String brandSurveyId) {
        this.brandSurveyId = brandSurveyId;
        return this;
    }

    public YTreeNode getBasicUplift() {
        return basicUplift;
    }

    public BrandSurveyStatusRow withBasicUplift(YTreeNode basicUplift) {
        this.basicUplift = basicUplift;
        return this;
    }
}
