package ru.yandex.direct.core.entity.campaign.model;

import java.util.Set;

import com.google.common.collect.Sets;

import static ru.yandex.direct.core.entity.campaign.model.CampaignSource.DIRECT;
import static ru.yandex.direct.core.entity.campaign.model.CampaignSource.EDA;
import static ru.yandex.direct.core.entity.campaign.model.CampaignSource.GEO;
import static ru.yandex.direct.core.entity.campaign.model.CampaignSource.UAC;
import static ru.yandex.direct.core.entity.campaign.model.CampaignSource.USLUGI;
import static ru.yandex.direct.core.entity.campaign.model.CampaignSource.ZEN;

public class CampaignSourceUtils {

    public static final Set<CampaignSource> ALL_CAMPAIGN_SOURCES = Set.of(CampaignSource.values());
    public static final Set<CampaignSource> API_DEFAULT_DISABLED_CAMPAIGN_SOURCES = Set.of(
            UAC, // универсальные кампании не доступны в АПИ
            // кампании созданные из приложений сервисов доступны для редактирования только для этих же приложений
            USLUGI,
            EDA,
            GEO,
            ZEN
    );
    public static final Set<CampaignSource> API_DEFAULT_CAMPAIGN_SOURCES =
            Sets.difference(ALL_CAMPAIGN_SOURCES, API_DEFAULT_DISABLED_CAMPAIGN_SOURCES);

    public static Set<CampaignSource> getApi5EditableSources(RequestSource requestSource) {
        if (requestSource == null) {
            requestSource = RequestSource.DEFAULT;
        }
        switch (requestSource) {
            case API_GEO:
                return Set.of(DIRECT, GEO);
            case API_USLUGI:
                return Set.of(DIRECT, USLUGI);
            case API_EDA:
                return Set.of(DIRECT, EDA);
            case API_K50:
                return Sets.union(API_DEFAULT_CAMPAIGN_SOURCES, Set.of(GEO));
            default:
                return API_DEFAULT_CAMPAIGN_SOURCES;
        }
    }

    public static Set<CampaignSource> getApi5VisibleSources(RequestSource requestSource) {
        if (requestSource == null) {
            requestSource = RequestSource.DEFAULT;
        }
        switch (requestSource) {
            case API_GEO:
                return Set.of(DIRECT, GEO);
            case API_USLUGI:
                return Set.of(DIRECT, USLUGI);
            case API_EDA:
                return Set.of(DIRECT, EDA);
            case API_K50:
                return Sets.union(API_DEFAULT_CAMPAIGN_SOURCES, Set.of(GEO));
            default:
                return API_DEFAULT_CAMPAIGN_SOURCES;
        }
    }
}
