package ru.yandex.direct.core.entity.campaign.model;

public final class CampaignWithType {
    /**
     * Идентификатор кампании
     */
    private final Long id;
    /**
     * Тип кампании
     */
    private final CampaignType type;
    /**
     * Признак архивности
     */
    private final boolean archived;

    public CampaignWithType(Long id, CampaignType type, boolean archived) {
        this.id = id;
        this.type = type;
        this.archived = archived;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        CampaignWithType campaign = (CampaignWithType) o;

        if (archived != campaign.archived) {
            return false;
        }
        if (!id.equals(campaign.id)) {
            return false;
        }
        return type == campaign.type;
    }

    @Override
    public int hashCode() {
        int result = id.hashCode();
        result = 31 * result + type.hashCode();
        result = 31 * result + (archived ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "CampaignWithType{" +
                "id=" + id +
                ", type=" + type +
                ", archived=" + archived +
                '}';
    }

    public Long getId() {
        return id;
    }

    public CampaignType getType() {
        return type;
    }

    public boolean isArchived() {
        return archived;
    }
}
