package ru.yandex.direct.core.entity.campaign.model;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.direct.core.entity.currency.model.cpmyndxfrontpage.FrontpageCampaignShowType;
import ru.yandex.direct.dbschema.ppcdict.enums.CpmYndxFrontpageMinBidsFrontpageType;

import static ru.yandex.direct.common.util.RepositoryUtils.setFromDb;


/**
 * Конвертация поля ppc.campaigns_cpm_yndx_frontpage.allowed_frontpage_types из значения в базе в Set ядровых моделей
 */
public class CpmYndxFrontpageShowTypeUtils {

    public static Set<FrontpageCampaignShowType> toFrontpageShowType(String value) {
        return setFromDb(value, singleShowType -> FrontpageCampaignShowType.fromSource(
                CpmYndxFrontpageMinBidsFrontpageType.valueOf(singleShowType)))
                .stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }
}
