package ru.yandex.direct.core.entity.campaign.model;

import javax.annotation.Nullable;

import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusautobudgetforecast;

public enum StatusAutobudgetForecast {

    /**
     * Значение нужно пересчитать
     */
    NEW,

    /**
     * Значение актуальное, автобюджет с указанными значениями выполним
     */
    VALID,

    /**
     * Значение актуальное, автобюджет с указанными значениями невыполним
     */
    WRONG;

    @Nullable
    public static CampaignsStatusautobudgetforecast toSource(StatusAutobudgetForecast statusAutobudgetForecast) {
        if (statusAutobudgetForecast == null) {
            return null;
        }
        switch (statusAutobudgetForecast) {
            case NEW:
                return CampaignsStatusautobudgetforecast.New;
            case VALID:
                return CampaignsStatusautobudgetforecast.Valid;
            case WRONG:
                return CampaignsStatusautobudgetforecast.Wrong;
            default:
                throw new IllegalStateException("unexpected type: " + statusAutobudgetForecast.name());
        }
    }
}
