package ru.yandex.direct.core.entity.campaign.model;

import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.dbutil.model.ClientId;

public class Wallet {
    private final long agencyClientId;
    private final Long walletCampaignId;
    private final ClientId clientId;
    private final Boolean isEnabled;
    private final Currency campaignsCurrency;

    public Wallet(long agencyClientId, Long walletCampaignId, ClientId clientId, Boolean isEnabled,
                  Currency campaignsCurrency) {
        this.agencyClientId = agencyClientId;
        this.walletCampaignId = walletCampaignId;
        this.clientId = clientId;
        this.isEnabled = isEnabled;
        this.campaignsCurrency = campaignsCurrency;
    }

    public boolean isAgencyWallet() {
        return agencyClientId != 0;
    }

    /**
     * Идентификатор ClientId агенства, к которому принадлежит кошелёк. В случае отсутствия -- 0L
     */
    public long getAgencyClientId() {
        return agencyClientId;
    }

    public Long getWalletCampaignId() {
        return walletCampaignId;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public Boolean getEnabled() {
        return isEnabled;
    }

    public Currency getCampaignsCurrency() {
        return campaignsCurrency;
    }
}
